﻿using System;
using System.Runtime.InteropServices;
using System.Windows.Forms;

namespace PWS.API.Socket.Sample2
{
    public partial class FormMain : Form
    {
        [StructLayout(LayoutKind.Sequential)]
        public struct WSAData
        {
            const int WSADescriptionLength = 256;
            const int WSASystemStatusLength = 128;

            public Int16 Version;
            public Int16 HighVersion;
            [MarshalAs(UnmanagedType.ByValTStr, SizeConst = WSADescriptionLength + 1)]
            public String Description;
            [MarshalAs(UnmanagedType.ByValTStr, SizeConst = WSASystemStatusLength + 1)]
            public String SystemStatus;
            public Int16 MaxSockets;
            public Int16 MaxUdpDg;
            public IntPtr VendorInfo;
        }

        public const short Success = 0;
        public const short HighVersion = 2;
        public const short LowVesion = 2;
        public const short WordVersion = HighVersion * 256 + LowVesion;

        [DllImport("ws2_32.dll")]
        public static extern Int32 WSAStartup(short wVersionRequested, ref WSAData wsaData);

        [DllImport("ws2_32.dll")]
        public static extern Int32 WSACleanup();

        public enum SocketType : short
        {
            /// <summary>
            /// stream socket
            /// </summary>
            SocketStream = 0x1,
            /// <summary>
            /// datagram socket
            /// </summary>
            SocketDatagram = 0x2,
            /// <summary>
            /// raw-protocol interface
            /// </summary>
            SocketRaw = 0x3,
            /// <summary>
            /// reliably-delivered message
            /// </summary>
            SocketRDM = 0x4,
            /// <summary>
            /// sequenced packet stream
            /// </summary>
            SocketSEQPacketStream = 0x5
        }

        public enum AddressFamilies : short
        {
            /// <summary>
            /// Unspecified [value = 0].
            /// </summary>
            AF_UNSPEC = 0x0,
            /// <summary>
            /// Local to host (pipes, portals) [value = 1].
            /// </summary>
            AF_UNIX = 0x1,
            /// <summary>
            /// Internetwork: UDP, TCP, etc [value = 2].
            /// </summary>
            AF_INET = 0x2,
            /// <summary>
            /// Arpanet imp addresses [value = 3].
            /// </summary>
            AF_IMPLINK = 0x3,
            /// <summary>
            /// Pup protocols: e.g. BSP [value = 4].
            /// </summary>
            AF_PUP = 0x4,
            /// <summary>
            /// Mit CHAOS protocols [value = 5].
            /// </summary>
            AF_CHAOS = 0x5,
            /// <summary>
            /// XEROX NS protocols [value = 6].
            /// </summary>
            AF_NS = 0x6,
            /// <summary>
            /// IPX protocols: IPX, SPX, etc [value = 6].
            /// </summary>
            AF_IPX = 0x6,
            /// <summary>
            /// ISO protocols [value = 7].
            /// </summary>
            AF_ISO = 0x7,
            /// <summary>
            /// OSI is ISO [value = 7].
            /// </summary>
            AF_OSI = 0x7,
            /// <summary>
            /// european computer manufacturers [value = 8].
            /// </summary>
            AF_ECMA = 0x8,
            /// <summary>
            /// datakit protocols [value = 9].
            /// </summary>
            AF_DATAKIT = 0x9,
            /// <summary>
            /// CCITT protocols, X.25 etc [value = 10].
            /// </summary>
            AF_CCITT = 0xA,
            /// <summary>
            /// IBM SNA [value = 11].
            /// </summary>
            AF_SNA = 0xB,
            /// <summary>
            /// DECnet [value = 12].
            /// </summary>
            AF_DECnet = 0xC,
            /// <summary>
            /// Direct data link interface [value = 13].
            /// </summary>
            AF_DLI = 0xD,
            /// <summary>
            /// LAT [value = 14].
            /// </summary>
            AF_LAT = 0xE,
            /// <summary>
            /// NSC Hyperchannel [value = 15].
            /// </summary>
            AF_HYLINK = 0xF,
            /// <summary>
            /// AppleTalk [value = 16].
            /// </summary>
            AF_APPLETALK = 0x10,
            /// <summary>
            /// NetBios-style addresses [value = 17].
            /// </summary>
            AF_NETBIOS = 0x11,
            /// <summary>
            /// VoiceView [value = 18].
            /// </summary>
            AF_VOICEVIEW = 0x12,
            /// <summary>
            /// Protocols from Firefox [value = 19].
            /// </summary>
            AF_FIREFOX = 0x13,
            /// <summary>
            /// Somebody is using this! [value = 20].
            /// </summary>
            AF_UNKNOWN1 = 0x14,
            /// <summary>
            /// Banyan [value = 21].
            /// </summary>
            AF_BAN = 0x15,
            /// <summary>
            /// Native ATM Services [value = 22].
            /// </summary>
            AF_ATM = 0x16,
            /// <summary>
            /// Internetwork Version 6 [value = 23].
            /// </summary>
            AF_INET6 = 0x17,
            /// <summary>
            /// Microsoft Wolfpack [value = 24].
            /// </summary>
            AF_CLUSTER = 0x18,
            /// <summary>
            /// IEEE 1284.4 WG AF [value = 25].
            /// </summary>
            AF_12844 = 0x19,
            /// <summary>
            /// IrDA [value = 26].
            /// </summary>
            AF_IRDA = 0x1A,
            /// <summary>
            /// Network Designers OSI &amp; gateway enabled protocols [value = 28].
            /// </summary>
            AF_NETDES = 0x1C,
            /// <summary>
            /// [value = 29].
            /// </summary>
            AF_TCNPROCESS = 0x1D,
            /// <summary>
            /// [value = 30].
            /// </summary>
            AF_TCNMESSAGE = 0x1E,
            /// <summary>
            /// [value = 31].
            /// </summary>
            AF_ICLFXBM = 0x1F
        }

        public enum ProtocolType : short
        {
            IP = 0x0,
            ICMP = 0x1,
            IGMP = 0x2,
            GGP = 0x3,
            TCP = 0x6,
            PUP = 0xC,
            UDP = 0x11,
            IDP = 0x16,
            IPV6 = 0x29,
            ND = 0x4D,
            ICLFXBM = 0x4E,
            Raw = 0xFF,
            Max = 0x100
        }

        [DllImport("ws2_32.dll")]
        public static extern IntPtr socket(AddressFamilies addressFamily, SocketType socketType, ProtocolType protocolType);

        [StructLayout(LayoutKind.Sequential)]
        public struct SocketAddress
        {
            public AddressFamilies AddressFamily;
            public ushort Port;
            public int IP;
            [MarshalAs(UnmanagedType.ByValArray, SizeConst = 8)]
            public byte[] sin_zero;
        }

        [DllImport("Ws2_32.dll")]
        public static extern int bind(IntPtr socketHandle, ref SocketAddress address, int addressSize);

        [DllImport("Ws2_32.dll")]
        public static extern int listen(IntPtr socketHandle, int backlog);

        [DllImport("Ws2_32.dll")]
        public static extern ushort htons(ushort hostShort);

        [DllImport("Ws2_32.dll", CharSet = CharSet.Ansi)]
        public static extern uint inet_addr(string ipString);

        public FormMain()
        {
            InitializeComponent();
        }

        private void ButtonListenClick(object sender, EventArgs e)
        {
            WSAData data = new WSAData();

            int result = WSAStartup(WordVersion, ref data);
            if (result != Success) return;
            IntPtr oursocket = socket(AddressFamilies.AF_INET, SocketType.SocketStream, ProtocolType.TCP);
            const int port = 55055;
            SocketAddress socketInfo = new SocketAddress();
            socketInfo.AddressFamily = AddressFamilies.AF_INET;
            socketInfo.IP = (int)inet_addr("127.0.0.1");
            socketInfo.Port = htons(port);
            bind(oursocket, ref socketInfo, Marshal.SizeOf(socketInfo));
            listen(oursocket, 0);
            WSACleanup();
        }
    }
}